/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.config.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.createmod.catnip.config.ui.BaseConfigScreen;
import net.createmod.catnip.config.ui.ConfigHelper;
import net.createmod.catnip.config.ui.ConfigScreen;
import net.createmod.catnip.config.ui.ConfigScreenList;
import net.createmod.catnip.config.ui.HintableTextFieldWidget;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.DelegatedStencilElement;
import net.createmod.catnip.gui.element.RenderElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class ConfigModListScreen
extends ConfigScreen {
    @Nullable
    ConfigScreenList list;
    @Nullable
    HintableTextFieldWidget search;
    @Nullable
    BoxWidget goBack;
    List<ModEntry> allEntries = new ArrayList<ModEntry>();

    public ConfigModListScreen(@Nullable class_437 parent) {
        super(parent);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int listWidth = Math.min(this.field_22789 - 80, 300);
        this.list = new ConfigScreenList(this.field_22787, listWidth, this.field_22790 - 60, 15, this.field_22790 - 45, 40);
        this.list.method_25333(this.field_22789 / 2 - this.list.getWidth() / 2);
        this.method_37063(this.list);
        this.allEntries = new ArrayList<ModEntry>();
        CatnipServices.PLATFORM.getLoadedMods().forEach(id -> this.allEntries.add(new ModEntry((String)id, this)));
        this.allEntries.sort((e1, e2) -> {
            int empty = (e2.button.field_22763 ? 1 : 0) - (e1.button.field_22763 ? 1 : 0);
            if (empty != 0) {
                return empty;
            }
            return e1.id.compareToIgnoreCase(e2.id);
        });
        this.list.method_25396().clear();
        this.list.method_25396().addAll(this.allEntries);
        this.goBack = (BoxWidget)((AbstractSimiWidget)new BoxWidget(this.field_22789 / 2 - listWidth / 2 - 30, this.field_22790 / 2 + 65, 20, 20).withPadding(2.0f, 2.0f)).withCallback(() -> ScreenOpener.open(this.parent));
        this.goBack.showingElement((RenderElement)PonderGuiTextures.ICON_CONFIG_BACK.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.goBack)));
        this.goBack.getToolTip().add((class_2561)class_2561.method_43471((String)"catnip.ui.go_back_button"));
        this.method_37063(this.goBack);
        this.search = new HintableTextFieldWidget(this.field_22793, this.field_22789 / 2 - listWidth / 2, this.field_22790 - 35, listWidth, 20);
        this.search.method_1863(this::updateFilter);
        this.search.method_47404((class_2561)class_2561.method_43471((String)"catnip.ui.search_hint"));
        this.search.method_1870();
        this.method_37063((class_364)this.search);
    }

    public boolean method_25402(double x, double y, int button) {
        if (this.search != null && !this.search.method_25405(x, y)) {
            this.search.method_25365(false);
        }
        return super.method_25402(x, y, button);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.search != null && class_437.method_25441() && keyCode == 70) {
            this.method_25395((class_364)this.search);
        }
        if (keyCode == 259) {
            ScreenOpener.open(this.parent);
        }
        return false;
    }

    private void updateFilter(String search) {
        assert (this.list != null);
        assert (this.search != null);
        this.list.method_25396().clear();
        for (ModEntry modEntry : this.allEntries) {
            if (!modEntry.id.contains(search.toLowerCase(Locale.ROOT))) continue;
            this.list.method_25396().add(modEntry);
        }
        this.list.method_25307(this.list.method_25341());
        if (!this.list.method_25396().isEmpty()) {
            this.search.method_1868(((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        } else {
            this.search.method_1868(((Color)AbstractSimiWidget.COLOR_FAIL.getFirst()).getRGB());
        }
    }

    public static class ModEntry
    extends ConfigScreenList.LabeledEntry {
        protected BoxWidget button;
        protected String id;

        public ModEntry(String id, class_437 parent) {
            super(CatnipServices.PLATFORM.getModDisplayName(id));
            this.id = id;
            this.button = (BoxWidget)new BoxWidget(0, 0, 35, 16).showingElement((RenderElement)PonderGuiTextures.ICON_CONFIG_OPEN.asStencil().at(10.0f, 0.0f));
            this.button.modifyElement(e -> ((DelegatedStencilElement)e).withElementRenderer(BoxWidget.gradientFactory.apply(this.button)));
            if (ConfigHelper.hasAnyForgeConfig(id)) {
                this.button.withCallback(() -> ScreenOpener.open(new BaseConfigScreen(parent, id)));
            } else {
                this.button.field_22763 = false;
                this.button.updateGradientFromState();
                this.button.modifyElement(e -> ((DelegatedStencilElement)e).withElementRenderer(BaseConfigScreen.DISABLED_RENDERER));
                this.labelTooltip.add(class_2561.method_43470((String)CatnipServices.PLATFORM.getModDisplayName(id)));
                this.labelTooltip.addAll(FontHelper.cutTextComponent((class_2561)class_2561.method_43471((String)"catnip.ui.other_mods_config_unavailable"), FontHelper.Palette.ALL_GRAY));
            }
            this.listeners.add(this.button);
        }

        public String getId() {
            return this.id;
        }

        @Override
        public void tick() {
            super.tick();
            this.button.tick();
        }

        @Override
        public void method_25343(class_332 graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            super.method_25343(graphics, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
            this.button.method_46421(x + width - 108);
            this.button.method_46419(y + 10);
            this.button.setHeight(height - 20);
            this.button.method_25394(graphics, mouseX, mouseY, partialTicks);
        }

        @Override
        protected int getLabelWidth(int totalWidth) {
            return (int)((float)totalWidth * 0.4f) + 30;
        }
    }
}

